#include "common_routines.h"

#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/enums.h>

#include <string>
#include <optional>

namespace maps::wiki::sync_fbapi_feedback {

namespace sf = social::feedback;

fbapi::ChangeTaskParams makeUpdateStatusParams(fbapi::TaskStatus status)
{
    fbapi::ChangeTaskParams params;
    params.setNewStatus(status);
    params.setActorService(fbapi::Service::Nmaps);

    if (status != fbapi::TaskStatus::NeedInfo) {
        // in case on need_info we don't know what service will process
        // this task further. it will be decided by FBAPI backend
        //
        params.setNewService(fbapi::Service::Nmaps);
    }

    return params;
}

fbapi::TaskStatus fbapiStatusFromSocialTask(const sf::Task& task)
{
    if (task.deployedAt()) {
        return fbapi::TaskStatus::Published;
    }

    if (task.bucket() == sf::Bucket::NeedInfo) {
        return fbapi::TaskStatus::NeedInfo;
    }

    if (task.resolved()) {
        if (task.resolved()->resolution.verdict() == sf::Verdict::Accepted) {
            return fbapi::TaskStatus::Accepted;
        } else {
            return fbapi::TaskStatus::Rejected;
        }
    }

    return fbapi::TaskStatus::InProgress;
}

} // namespace maps::wiki::sync_fbapi_feedback
