#include "decode_coordinates.h"
#include <maps/libs/common/include/base64.h>
#include <maps/libs/geolib/include/vector.h>

#include <endian.h>

namespace maps::wiki::sync_fbapi_feedback {

namespace {

constexpr double CODING_COEFFICIENT = 1000000.;

geolib3::Vector2 readPoint(uint32_t xData, uint32_t yData)
{
    return geolib3::Vector2(
        static_cast<int32_t>(le32toh(xData)) / CODING_COEFFICIENT,
        static_cast<int32_t>(le32toh(yData)) / CODING_COEFFICIENT
    );
}

}  // unnamed namespace

/// encodedCoordinates - is base64 encoded binary data of
/// (int32_t deltaX, int32 deltaY) pairs stored in little endian order.
/// Point[0] = delta[0]
/// Point[n] = Point[n-1] + delta[n]
geolib3::PointsVector decodeCoordinates(const std::string& encodedCoordinates)
{
    geolib3::PointsVector retVal;
    auto res = base64Decode(encodedCoordinates);

    const uint32_t* dwords = reinterpret_cast<const uint32_t*>(res.data());
    size_t dwordsSize = res.size() / sizeof(*dwords);
    size_t index = 0;
    geolib3::Point2 prev(0, 0);

    while ((index + 2) <= dwordsSize) {
        prev += readPoint(dwords[index], dwords[index + 1]);
        retVal.push_back(prev);
        index += 2;
    }
    return retVal;
}

} // namespace maps::wiki::sync_fbapi_feedback
