#include "fbapi_update_extra_data.h"

#include <maps/libs/common/include/exception.h>
#include <optional>

namespace maps::wiki::sync_fbapi_feedback {

namespace sf = social::feedback;

std::optional<fbapi::TaskResolution> getTaskResolution(std::optional<sf::RejectReason> rejectReason)
{
    if (!rejectReason) {
        return std::nullopt;
    }

    switch (*rejectReason) {
        case sf::RejectReason::AutoCleanWeb:
            return fbapi::TaskResolution::AutoCleanWeb;

        case sf::RejectReason::IncorrectData:
            return fbapi::TaskResolution::IncorrectData;

        case sf::RejectReason::NoData:
            return fbapi::TaskResolution::NoData;

        case sf::RejectReason::NoInfo:
            return fbapi::TaskResolution::NoInfo;

        case sf::RejectReason::ProhibitedByRules:
            return fbapi::TaskResolution::ProhibitedByRules;

        case sf::RejectReason::RedirectToContentAuto:
            return fbapi::TaskResolution::RedirectToContentAuto;

        case sf::RejectReason::RedirectToContentBicycle:
            return fbapi::TaskResolution::RedirectToContentBicycle;

        case sf::RejectReason::RedirectToContentBigTask:
            return fbapi::TaskResolution::RedirectToContentBigTask;

        case sf::RejectReason::RedirectToContentMasstransit:
            return fbapi::TaskResolution::RedirectToContentMasstransit;

        case sf::RejectReason::RedirectToContentOther:
            return fbapi::TaskResolution::RedirectToContentOther;

        case sf::RejectReason::RedirectToContentPedestrian:
            return fbapi::TaskResolution::RedirectToContentPedestrian;

        case sf::RejectReason::RedirectToContentRoadEvents:
            return fbapi::TaskResolution::RedirectToContentRoadEvents;

        case sf::RejectReason::RedirectToContentToponym:
            return fbapi::TaskResolution::RedirectToContentToponym;

        case sf::RejectReason::RedirectToContentTruck:
            return fbapi::TaskResolution::RedirectToContentTruck;

        case sf::RejectReason::RedirectToPlatformAuto:
            return fbapi::TaskResolution::RedirectToPlatformAuto;

        case sf::RejectReason::RedirectToPlatformBicycle:
            return fbapi::TaskResolution::RedirectToPlatformBicycle;

        case sf::RejectReason::RedirectToPlatformMasstransit:
            return fbapi::TaskResolution::RedirectToPlatformMasstransit;

        case sf::RejectReason::RedirectToPlatformToponym:
            return fbapi::TaskResolution::RedirectToPlatformToponym;

        case sf::RejectReason::RedirectToPlatformTruck:
            return fbapi::TaskResolution::RedirectToPlatformTruck;

        case sf::RejectReason::RedirectToSprav:
            return fbapi::TaskResolution::RedirectToSprav;

        case sf::RejectReason::RedirectToSupport:
            return fbapi::TaskResolution::RedirectToSupport;

        case sf::RejectReason::Spam:
            return fbapi::TaskResolution::Spam;

        case sf::RejectReason::NoProcess:
            throw maps::RuntimeError() << "Invalid reject reason " << *rejectReason;
    }
    return std::nullopt;
}

FbapiUpdateExtraData FbapiUpdateExtraData::createForNeedInfo(
    std::string message,
    std::optional<std::string> requestTemplate)
{
    return FbapiUpdateExtraData(
        std::move(message), std::move(requestTemplate), std::nullopt);
}

FbapiUpdateExtraData FbapiUpdateExtraData::createForReject(
    std::optional<std::string> message,
    const std::optional<sf::RejectReason>& rejectReason)
{
    std::optional<fbapi::TaskResolution> taskResolution;
    if (rejectReason) {
        taskResolution = getTaskResolution(*rejectReason);
    }
    return FbapiUpdateExtraData(
        std::move(message), std::nullopt, std::move(taskResolution));
}

fbapi::ChangeTaskParams FbapiUpdateExtraData::makeParams() const
{
    fbapi::ChangeTaskParams params;

    if (message_) {
        params.setMessage(*message_);
    }
    if (requestTemplate_) {
        params.setRequestTemplateId(*requestTemplate_);
    }
    if (taskResolution_) {
        params.setResolution(*taskResolution_);
    }

    return params;
}

FbapiUpdateExtraData::FbapiUpdateExtraData(
    std::optional<std::string> message,
    std::optional<std::string> requestTemplate,
    std::optional<fbapi::TaskResolution> taskResolution)
    : message_(std::move(message))
    , requestTemplate_(std::move(requestTemplate))
    , taskResolution_(std::move(taskResolution))
{}

} // namespace maps::wiki::sync_fbapi_feedback
