#pragma once

#include <maps/wikimap/mapspro/libs/http/include/yandex/maps/wiki/http/fbapi/method_params.h>

#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/http/fbapi/models/common.h>

#include <string>
#include <optional>

namespace maps::wiki::sync_fbapi_feedback {

std::optional<fbapi::TaskResolution> getTaskResolution(
    std::optional<social::feedback::RejectReason> rejectReason);

class FbapiUpdateExtraData
{
public:
    static FbapiUpdateExtraData createForNeedInfo(
        std::string message,
        std::optional<std::string> requestTemplate);

    static FbapiUpdateExtraData createForReject(
        std::optional<std::string> message,
        const std::optional<social::feedback::RejectReason>& rejectReason);

    const std::optional<std::string>& message() const { return message_; }
    const std::optional<std::string>& requestTemplate() const { return requestTemplate_; }
    const std::optional<fbapi::TaskResolution>& taskResolution() const { return taskResolution_; }

    fbapi::ChangeTaskParams makeParams() const;

private:
    FbapiUpdateExtraData(
        std::optional<std::string> message,
        std::optional<std::string> requestTemplate,
        std::optional<fbapi::TaskResolution> taskResolution);

    std::optional<std::string> message_;
    std::optional<std::string> requestTemplate_;
    std::optional<fbapi::TaskResolution> taskResolution_;
};

} // namespace maps::wiki::sync_fbapi_feedback
