#include "mt_router_client.h"

#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/enum_io/include/enum_io.h>

#include <iomanip>
#include <ios>
#include <sstream>

namespace mp = yandex::maps::proto;

namespace maps::wiki::sync_fbapi_feedback {

MTRouterClient::MTRouterClient(RouterConfig configuration)
    : configuration_(std::move(configuration))
{
    httpClient_.setTimeout(configuration_.timeout());
}

yandex::maps::proto::common2::response::Response
MTRouterClient::uri(const std::string& urlPath, const std::string& uri) const
{
    auto url = configuration_.url();
    url.setPath(urlPath);
    url.addParam("uri", uri);

    http::HeaderMap headerMap;
    if (configuration_.tvmTicketProvider()) {
        headerMap.emplace(auth::SERVICE_TICKET_HEADER, configuration_.tvmTicketProvider()());
    }

    auto [responseBody, status] = httpClient_.get(
        url,
        headerMap,
        configuration_.retryPolicy());

    REQUIRE(status == 200, "Unexpected code " << status
        << " for request: " << url.toString());

    mp::common2::response::Response message;
    REQUIRE(message.ParseFromString(TProtoStringType{responseBody}),
        "failed to parse mt-router response at request: " << url.toString());

    return message;
}

yandex::maps::proto::common2::response::Response
MTRouterClient::mtUri(const std::string& uriString) const
{
    return uri("/masstransit/v2/uri", uriString);
}

yandex::maps::proto::common2::response::Response
MTRouterClient::pedestrianUri(const std::string& uriString) const
{
    return uri("/pedestrian/v2/uri", uriString);
}

} // namespace maps::wiki::sync_fbapi_feedback
