#pragma once

#include "router_config.h"

#include <maps/libs/http/include/http.h>
#include <maps/doc/proto/yandex/maps/proto/common2/response.pb.h>

namespace maps::wiki::sync_fbapi_feedback {

class MTRouterClient {
public:
    explicit MTRouterClient(RouterConfig configuration);

    yandex::maps::proto::common2::response::Response
    mtUri(const std::string& uri) const;

    yandex::maps::proto::common2::response::Response
    pedestrianUri(const std::string& uri) const;

private:
    yandex::maps::proto::common2::response::Response
    uri(const std::string& urlPath, const std::string& uri) const;

    RouterConfig configuration_;
    mutable http::Client httpClient_;
};

} // maps::wiki::sync_fbapi_feedback
