#include "position_diff.h"
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/serialization.h>

namespace maps::wiki::sync_fbapi_feedback {

namespace {

geolib3::BoundingBox boundingBox(const PositionDiff& posDiff)
{
    return geolib3::BoundingBox(posDiff.before, posDiff.after);
}

} // anonymous

PositionDiff::PositionDiff(
    const geolib3::Point2& before,
    const geolib3::Point2& after) :
        before(before),
        after(after)
{}

void PositionDiff::json(json::ObjectBuilder builder) const
{
    const auto bounds = boundingBox(*this);
    builder["bounds"] << [&](json::ArrayBuilder arrayBuilder) {
        arrayBuilder << bounds.minX();
        arrayBuilder << bounds.minY();
        arrayBuilder << bounds.maxX();
        arrayBuilder << bounds.maxY();
    };

    builder["modified"] << [&](json::ObjectBuilder builder) {
        builder["geometry"] << [&](json::ObjectBuilder builder) {
            builder["before"] << [&](json::ArrayBuilder builder) {
                builder << geolib3::geojson(before);
            };
            builder["after"] << [&](json::ArrayBuilder builder) {
                builder << geolib3::geojson(after);
            };
        };
    };
}

} // namespace maps::wiki::sync_fbapi_feedback
