#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/json/include/builder.h>

namespace maps::wiki::sync_fbapi_feedback {

struct PositionDiff
{
    PositionDiff(const geolib3::Point2& before, const geolib3::Point2& after);

    // Construct JSON object according to schema
    // social.common.schema.json#/definitions/objectDiffType
    void json(json::ObjectBuilder builder) const;

    geolib3::Point2 before;
    geolib3::Point2 after;
};

} // namespace maps::wiki::sync_fbapi_feedback
