#include "route.h"

#include <maps/libs/geolib/include/polyline.h>
#include <yandex/maps/geolib3/proto.h>

namespace mp = yandex::maps::proto;

namespace maps::wiki::sync_fbapi_feedback {

namespace {

void collectAllGeometry(
    geolib3::Polyline2& lineResult,
    const mp::common2::geo_object::GeoObject& geoObject)
{
    for (const auto& geometry : geoObject.geometry()) {
        if (geometry.has_polyline()) {
            lineResult.extend(
                geolib3::proto::decode(geometry.polyline()),
                geolib3::EndPointMergePolicy::MergeEqualPoints);
        }
    }
    for (const auto& innerGeoObject : geoObject.geo_object()) {
        collectAllGeometry(lineResult, innerGeoObject);
    }
}

} // unnamed namespace

Route::Route(const mp::common2::response::Response& response)
{
    collectAllGeometry(routePointsGeodetic_, response.reply());
}

} // namespace maps::wiki::sync_fbapi_feedback
