#pragma once

#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/http/fbapi/models/route_answer_context.h>
#include <yandex/maps/wiki/http/fbapi/models/route_question_context.h>
#include <maps/libs/json/include/builder.h>

#include <optional>
#include <string>

namespace maps::wiki::sync_fbapi_feedback {

class RouteContext
{
public:
    RouteContext(
        fbapi::TravelMode travelMode,
        bool trafficJams,
        geolib3::PointsVector wayPointsMercator,
        geolib3::PointsVector pointsGeodetic,
        fbapi::RouteQuestionSegments segments);

    RouteContext& setViaPointsMercator(geolib3::PointsVector viaPointsMercator);
    RouteContext& setUserErrors(fbapi::RouteErrors userErrors);
    RouteContext& setUserRoute(fbapi::RouteAnswerSegments userRoute);
    RouteContext& setUri(std::string uri);
    RouteContext& setDepartureAt(chrono::TimePoint timePoint);
    RouteContext& setVehicleRestrictions(fbapi::VehicleRestrictions);

    // Construct JSON object according to schema
    // social/source_contexts/route_context.schema.json
    void json(json::ObjectBuilder builder) const;

private:
    fbapi::TravelMode travelMode_;
    bool trafficJams_;
    geolib3::PointsVector wayPointsMercator_;
    geolib3::PointsVector viaPointsMercator_;
    geolib3::PointsVector pointsGeodetic_;
    std::optional<std::string> uri_;
    fbapi::RouteQuestionSegments segments_;
    fbapi::RouteErrors userErrors_;
    fbapi::RouteAnswerSegments userRoute_;
    std::optional<chrono::TimePoint> departureAt_;
    std::optional<fbapi::VehicleRestrictions> vehicleRestrictions_;
};

} // namespace maps::wiki::sync_fbapi_feedback
