#include "router_config.h"

namespace maps::wiki::sync_fbapi_feedback {

RouterConfig::RouterConfig(http::URL url)
    : url_(std::move(url))
{}

RouterConfig& RouterConfig::setTimeout(std::chrono::seconds value)
{
    timeout_ = value;
    return *this;
}

RouterConfig& RouterConfig::setRetryPolicy(common::RetryPolicy policy)
{
    retryPolicy_ = std::move(policy);
    return *this;
}


RouterConfig& RouterConfig::setTvmTicketProvider(TvmTicketProvider tvmTicketProvider)
{
    tvmTicketProvider_ = std::move(tvmTicketProvider);
    return *this;
}

} // namespace maps::wiki::sync_fbapi_feedback::drouter_client
