#pragma once

#include <maps/libs/http/include/http.h>
#include <maps/libs/common/include/retry.h>

#include <chrono>
#include <functional>
#include <string>

namespace maps::wiki::sync_fbapi_feedback {

using TvmTicketProvider = std::function<std::string()>;

class RouterConfig
{
public:
    explicit RouterConfig(http::URL url);

    RouterConfig& setTimeout(std::chrono::seconds);
    RouterConfig& setRetryPolicy(common::RetryPolicy);
    RouterConfig& setTvmTicketProvider(TvmTicketProvider tvmTicketProvider);

    const http::URL& url() const { return url_; }
    std::chrono::seconds timeout() const { return timeout_; }
    const common::RetryPolicy& retryPolicy() const { return retryPolicy_; }
    const TvmTicketProvider& tvmTicketProvider() const { return tvmTicketProvider_; };

private:
    http::URL url_;
    std::chrono::seconds timeout_{60};
    common::RetryPolicy retryPolicy_;
    TvmTicketProvider tvmTicketProvider_;
};

} // namespace maps::wiki::sync_fbapi_feedback
