#pragma once

#include "maps/libs/geolib/include/fwd.h"
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/json/include/builder.h>

#include <optional>

namespace maps::wiki::sync_fbapi_feedback {

class SiteAndSpotsAsObjectDiff
{
public:
    SiteAndSpotsAsObjectDiff& setMercatorSiteBefore(geolib3::Polyline2);
    SiteAndSpotsAsObjectDiff& setMercatorSiteAfter(geolib3::Polyline2);
    SiteAndSpotsAsObjectDiff& setMercatorPointsBefore(geolib3::PointsVector);
    SiteAndSpotsAsObjectDiff& setMercatorPointsAfter(geolib3::PointsVector);

    // Construct JSON object according to schema
    // social.common.schema.json#/definitions/objectDiffType
    void json(json::ObjectBuilder builder) const;

private:
    std::optional<geolib3::Polyline2> mercatorSiteBefore_;
    std::optional<geolib3::Polyline2> mercatorSiteAfter_;
    geolib3::PointsVector mercatorPointsBefore_;
    geolib3::PointsVector mercatorPointsAfter_;
};

} // namespace maps::wiki::sync_fbapi_feedback
