#include "uri_resolver.h"

#include <yandex/maps/proto/search/geocoder.pb.h>

namespace maps::wiki::sync_fbapi_feedback {

namespace mp = yandex::maps::proto;

namespace {

std::optional<std::string> extractObjectId(const mp::common2::response::Response& response)
{
    for (const auto& geoObject : response.reply().geo_object()) {
        for (const auto& metadata : geoObject.metadata()) {
            if (!metadata.HasExtension(mp::search::geocoder::GEO_OBJECT_METADATA)) {
                continue;
            }
            auto geoObjectMetadata = metadata.GetExtension(mp::search::geocoder::GEO_OBJECT_METADATA);
            if (!geoObjectMetadata.Hasid()) {
                continue;
            }
            return geoObjectMetadata.id();
        }
    }
    return std::nullopt;
}

} // unnamed namespace

std::optional<std::string> UriResolver::resolveObjectUri(const std::string& uri)
{
    auto response = geosearch_.search(geosearch_client::SearchParams()
        .setLang("ru")
        .setUri(uri));
    return extractObjectId(response);
}

std::optional<Route> UriResolver::resolveDrivingRouteUri(const std::string& uri)
{
    auto response = drouter_.uri(uri);
    return Route(response);
}

std::optional<Route> UriResolver::resolveMtRouteUri(const std::string& uri)
{
    auto response = mtRouter_.mtUri(uri);
    return Route(response);
}

std::optional<Route> UriResolver::resolvePedestrianRouteUri(const std::string& uri)
{
    auto response = mtRouter_.pedestrianUri(uri);
    return Route(response);
}

std::optional<Route> UriResolver::resolveBicycleRouteUri(const std::string& uri)
{
    auto response = bicycleRouter_.uri(uri);
    return Route(response);
}

std::optional<Route> UriResolver::resolveScooterRouteUri(const std::string& uri)
{
    auto response = bicycleRouter_.uri(uri);
    return Route(response);
}

} // namespace maps::wiki::sync_fbapi_feedback
