#pragma once

#include "router_uri_client.h"
#include "fbapi_issue_parser.h"
#include "mt_router_client.h"

#include <maps/libs/geosearch_client/include/client.h>

namespace maps::wiki::sync_fbapi_feedback {

class UriResolver : public IUriResolver
{
public:
    UriResolver(
        geosearch_client::Client geosearch,
        ResolveUriFromRouterClient drouter,
        MTRouterClient mtRouter,
        ResolveUriFromRouterClient bicycleRouter)
        : geosearch_(std::move(geosearch))
        , drouter_(std::move(drouter))
        , mtRouter_(std::move(mtRouter))
        , bicycleRouter_(std::move(bicycleRouter))
    {}

    std::optional<std::string> resolveObjectUri(const std::string&) override;
    std::optional<Route> resolveDrivingRouteUri(const std::string&) override;
    std::optional<Route> resolveMtRouteUri(const std::string&) override;
    std::optional<Route> resolvePedestrianRouteUri(const std::string&) override;
    std::optional<Route> resolveBicycleRouteUri(const std::string&) override;
    std::optional<Route> resolveScooterRouteUri(const std::string&) override;

private:
    geosearch_client::Client geosearch_;
    ResolveUriFromRouterClient drouter_;
    MTRouterClient mtRouter_;
    ResolveUriFromRouterClient bicycleRouter_;
};

} // namespace maps::wiki::sync_fbapi_feedback
