#pragma once

#include "uri_resolver.h"

#include <library/cpp/tvmauth/client/facade.h>
#include <yandex/maps/wiki/http/fbapi/gateway.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/tasks/status_writer.h>

namespace maps::wiki::sync_fbapi_feedback {

class Worker
{
public:
    Worker(const common::ExtendedXmlDoc& cfg,
        tasks::StatusWriter& statusWriter);

    void doTask();

private:
    common::PoolHolder socialPool_;
    NTvmAuth::TTvmClient tvmClient_;
    fbapi::Gateway fbapiGateway_;
    tasks::StatusWriter& statusWriter_;
    UriResolver uriResolver_;
};

} // namespace maps::wiki::sync_fbapi_feedback
