#include "mock_fbapi_gtw.h"
#include <library/cpp/testing/common/env.h>

namespace maps::wiki::sync_fbapi_feedback::tests {

namespace {

std::string fileName(const std::string& datasetName)
{
    return SRC_("data/fbapi-mock/" + datasetName + ".json");
}

} // unnamed namespace

MockFeedbackGateway::MockFeedbackGateway(std::string datasetName)
    : datasetName_(datasetName)
{}

fbapi::Task MockFeedbackGateway::taskById(
    const std::string& id, fbapi::WithHistory) const
{
    auto tasks = fbapi::Tasks(
        json::Value::fromFile(fileName(datasetName_))
    );

    for (const auto& task : tasks.tasks()) {
        if (task.id() == id) {
            return task;
        }
    }

    throw fbapi::KeyNotFoundError();
}

fbapi::Tasks MockFeedbackGateway::tasksByFilter(
    const fbapi::TasksFilter&,
    const fbapi::PageParams& pageParams,
    fbapi::WithHistory) const
{
    if (pageParams.offset() == 0) {
        return fbapi::Tasks(
            json::Value::fromFile(fileName(datasetName_))
        );
    } else {
        return fbapi::Tasks(json::Value::fromString("{\"tasks\": []}"));
    }
}

void MockFeedbackGateway::changeTaskById(
    const std::string& taskId,
    const fbapi::ChangeTaskParams& params)
{
    changedTasks_[taskId] = params;
}

std::set<std::string> MockFeedbackGateway::changedTaskIds() const
{
    std::set<std::string> retVal;
    for(auto const& imap: changedTasks_) {
        retVal.insert(imap.first);
    }
    return retVal;
}

const fbapi::ChangeTaskParams& MockFeedbackGateway::changedTaskParams(const std::string& id) const
{
    return changedTasks_.at(id);
}

} // namespace maps::wiki::sync_fbapi_feedback::tests
