#pragma once

#include <yandex/maps/wiki/http/fbapi/gateway.h>
#include <yandex/maps/wiki/http/fbapi/models/task.h>

#include <map>
#include <set>
#include <string>

namespace maps::wiki::sync_fbapi_feedback::tests {

class MockFeedbackGateway: public fbapi::IGateway
{
public:
    explicit MockFeedbackGateway(std::string datasetName);

    fbapi::Task taskById(const std::string& id, fbapi::WithHistory) const override;

    fbapi::Tasks tasksByFilter(
        const fbapi::TasksFilter&,
        const fbapi::PageParams&,
        fbapi::WithHistory) const override;

    void changeTaskById(const std::string& taskId, const fbapi::ChangeTaskParams&) override;

    std::set<std::string> changedTaskIds() const;
    const fbapi::ChangeTaskParams& changedTaskParams(const std::string& id) const;

private:
    std::string datasetName_;
    std::map<std::string, fbapi::ChangeTaskParams> changedTasks_;
};

} // namespace maps::wiki::sync_fbapi_feedback::tests
