#pragma once

#include <maps/libs/geolib/include/serialization.h>
#include <maps/tools/grinder/worker/include/api.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/validator/storage/message_attributes_filter.h>
#include <yandex/maps/wiki/validator/storage/results_gateway.h>
#include <optional>

namespace worker = maps::grinder::worker;

namespace maps::wiki::validation_feedback_converter {

std::optional<geolib3::Point2> getPoint2FromWkb(const std::string& geomWkb);

validator::storage::StoredMessageData getNewValidationTasksData(
    uint64_t validationTaskId,
    const validator::storage::MessageAttributesFilter& filter,
    pqxx::transaction_base& validationTxn,
    pqxx::transaction_base& coreTxn);

size_t createFeedbackTasks(
    const validator::storage::StoredMessageData& tasksData,
    pqxx::transaction_base& socialTxn,
    pqxx::transaction_base& coreTxn);

class Worker {
public:
    explicit Worker(std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> configXml);

    void doTask(const worker::Task& task);
private:
    std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> configXml_;
};

} // namespace maps::wiki::validation_feedback_converter
