#pragma once

#include "common.h"
#include "task_params.h"
#include "object.h"
#include "message_reporter.h"

namespace maps {
namespace wiki {
namespace importer {

/**
Add new objects to DB via revisionapi
Objects are processed as a list (without recursive traversal)
*/
CommitIds addObjects(
    const Objects& objects,
    const DbIdToFeatureIdMap& idMap,
    TaskParams& params,
    tasks::TaskPgLogger& logger,
    MessageReporter& messageReporter);

struct RelationToAdd
{
    TObjectId masterId;
    TObjectId slaveId;
    StringMap attributes;
};

/**
Add relations between already existing objects
*/
CommitIds addRelations(
    const std::vector<RelationToAdd>& relations,
    TaskParams& params);

} // importer
} // wiki
} // maps
