#pragma once

#include "common.h"
#include "task_params.h"
#include "object.h"
#include "message_reporter.h"

namespace maps {
namespace wiki {
namespace importer {

/**
Deletes only relations by given revision ids
*/
CommitIds deleteRelations(
    const revision::RevisionIds& relations,
    TaskParams& params);

/**
Deletes objects with relations and slaves
*/
CommitIds deleteObjectsWithTableAttributes(
    const ObjectIds& objectIds,
    TaskParams& params,
    MessageReporter& messageReporter);

} // importer
} // wiki
} // maps
