#pragma once

#include "common.h"
#include "task_params.h"
#include "object.h"
#include "message_reporter.h"

namespace maps {
namespace wiki {
namespace importer {

struct DispatchResult
{
    CommitIds commitIds;
    ObjectIds skippedObjectIds;
};

/**
Returns commit ids and skipped object ids
*/
DispatchResult dispatchObjects(
    const ObjectsCache& cache,
    TaskParams& params,
    tasks::TaskPgLogger& logger,
    MessageReporter& messageReporter);

} // importer
} // wiki
} // maps
