#include "editor_config.h"

namespace maps {
namespace wiki {
namespace importer {

EditorConfig::EditorConfig(const std::string& configPath)
    : cfg::ConfigHolder(configPath)
{
}

bool EditorConfig::hasCategory(const std::string& id) const
{
    return categories().defined(id);
}

const cfg::Category& EditorConfig::category(const std::string& id) const
{
    return categories()[id];
}

const cfg::Rubrics& EditorConfig::rubrics() const
{
    return externals().rubrics();
}

} // importer
} // wiki
} // maps
