#pragma once

#include "common.h"

#include <yandex/maps/wiki/configs/editor/config_holder.h>
#include <yandex/maps/wiki/configs/editor/categories.h>
#include <yandex/maps/wiki/configs/editor/externals.h>

namespace cfg = maps::wiki::configs::editor;

namespace maps {
namespace wiki {
namespace importer {

class EditorConfig : public cfg::ConfigHolder
{
public:
    explicit EditorConfig(const std::string& configPath);

    bool hasCategory(const std::string& id) const;
    const cfg::Category& category(const std::string& id) const;
    const cfg::Rubrics& rubrics() const;
};

} // importer
} // wiki
} // maps
