#pragma once

#include "common.h"
#include "editor_config.h"
#include "import_config.h"
#include "object.h"
#include "message_reporter.h"

#include <filesystem>

namespace maps {
namespace wiki {
namespace importer {

/// @brief Converts geodata files to objects
Objects gdal2objects(
        const std::filesystem::path& dataDir,
        Action action,
        ObjectsCache& cache,
        const EditorConfig& editorConfig,
        const ImportConfig& importConfig,
        MessageReporter& messageReporter);

} // importer
} // wiki
} // maps
