#pragma once

#include "common.h"

#include <optional>
#include <unordered_map>
#include <unordered_set>

namespace maps {
namespace wiki {
namespace importer {

struct MasterRelationInfo
{
    std::string masterCategoryId;
    std::string role;
};

struct FutureMasterRelationInfo
{
    std::string masterLayer;
    std::string role;
};

class ImportConfig
{
public:
    ImportConfig();

    /**
    Returns attribute name if fieldName is an alias for attribute.
    Returns original fieldName otherwise.
    */
    std::string getAttributeName(
        const std::string& categoryId,
        const std::string& fieldName) const;

    std::optional<MasterRelationInfo> getMasterRelation(
        const std::string& slaveCategoryId,
        const std::string& fieldName) const;

    std::optional<FutureMasterRelationInfo> getFutureMasterRelation(
        const std::string& slaveCategoryId,
        const std::string& fieldName) const;

    std::optional<FutureMasterRelationInfo> getIndoorFutureMasterRelationInfo(
        const std::string& slaveCategoryId) const;

    const std::unordered_set<std::string>& requiredFields(
        const std::string& categoryId) const;

    bool isCategoryAllowedToDelete(
        const std::string& categoryId) const;

private:
    using AttributeAliasMap = std::unordered_map<std::string, std::string>;
    AttributeAliasMap commonAttributeAliases_;
    std::unordered_map<std::string, AttributeAliasMap> categoryAttributeAliases_;

    using RelationAliasMap = std::unordered_map<std::string, MasterRelationInfo>;
    std::unordered_map<std::string, RelationAliasMap> categoryRelationAliases_;

    using FutureRelationAliasMap = std::unordered_map<std::string, FutureMasterRelationInfo>;
    std::unordered_map<std::string, FutureRelationAliasMap> categoryFutureRelationAliases_;

    std::unordered_map<std::string, FutureMasterRelationInfo> layerNameFutureRelations_;
    std::unordered_map<std::string, std::unordered_set<std::string>> categoryRequiredFields_;

    std::unordered_set<std::string> allowedCategoryIdsToDelete_;
};

} // importer
} // wiki
} // maps
