#pragma once

#include "common.h"
#include "editor_config.h"

#include <yandex/maps/wiki/configs/editor/restrictions.h>

namespace maps {
namespace wiki {
namespace importer {

struct OGRGeometryDeleter
{
    void operator()(OGRGeometry* ogrGeometry)
    {
        OGRGeometryFactory::destroyGeometry(ogrGeometry);
    }
};

using OGRLineStringPtr = std::unique_ptr<OGRLineString, OGRGeometryDeleter>;

class LineSplitter
{
public:
    explicit LineSplitter(const cfg::Restrictions& restrictions);

    std::vector<OGRLineStringPtr> split(const OGRLineString* inputLine) const;

private:
    const cfg::Restrictions& restrictions_;
};

} // namespace importer
} // namespace wiki
} // namespace maps
