#pragma once

#include "common.h"

#include <boost/optional.hpp>

#include <sstream>

namespace maps {
namespace wiki {
namespace importer {

class Message
{
public:
    Message() = default;

    Message(ID id)
        : id_(std::move(id))
    {}

    ~Message() = default;

    Message(const Message&) = delete;
    Message& operator=(const Message&) = delete;

    Message(Message&&) = default;
    Message& operator=(Message&&) = default;

    template<typename T>
    Message& operator<<(const T& val)
    {
        text_ << val;
        return *this;
    }

    std::string text() const { return text_.str(); }

    const std::optional<ID>& id() const { return id_; }

private:
    std::ostringstream text_;
    std::optional<ID> id_;
};

} // namespace importer
} // namespace wiki
} // namespace maps
