#pragma once

#include "message.h"

#include <vector>

namespace maps {
namespace wiki {
namespace importer {

class MessageReporter
{
public:
    MessageReporter()
        : hasErrors_(false)
    {}

    template<typename... Args>
    std::vector<Message>::reference error(Args... args)
    {
        hasErrors_ = true;
        messages_.emplace_back(std::forward<Args>(args)...);
        return messages_.back();
    }

    template<typename... Args>
    std::vector<Message>::reference warning(Args... args)
    {
        messages_.emplace_back(std::forward<Args>(args)...);
        return messages_.back();
    }

    const std::vector<Message>& messages() const { return messages_; }

    bool hasErrors() const { return hasErrors_; }
    size_t size() const { return messages_.size(); }

private:
    bool hasErrors_;
    std::vector<Message> messages_;
};

} // namespace importer
} // namespace wiki
} // namespace maps
