#pragma once

#include <unordered_map>
#include <unordered_set>

#include "common.h"
#include "editor_config.h"

namespace maps::wiki::importer {

using RubricId = uint64_t;

/*
 *   RubricsMatcher class used to find `category` and `ft_type`
 *   using value of `type`, `rubric` and `rubric_id` fields
*/

class RubricsMatcher
{
public:
    RubricsMatcher(const EditorConfig& editorConfig);

/*
 *  Used to match value of fields `rubric` or `rubric_id` to object category
*/
    std::string rubricToCategory(
        const std::string& rubric) const;

    bool isCategoryAvaliable(
        const std::string& categoryId) const;

    bool isFieldNameMatched(
        const std::string& categoryId,
        const std::string& rubricType) const;

    std::optional<std::string> getFtType(
        const std::string& rubricType,
        const std::string& rubricId) const;

private:
    const EditorConfig& editorConfig_ ;
    std::unordered_map<std::string, std::string> ftTypeToCategory_;
    std::unordered_map<RubricId, std::string> rubricToCategory_;

    std::unordered_set<std::string> avaliableCategoryIds_;

    using MatchInfo = std::unordered_map<std::string, std::string>; // ex: { business -> 2401 }
    std::unordered_map<std::string, MatchInfo> rubricTypeRelationMap_; // ex: { type -> { business -> 2401 } }
};

} // maps::wiki::importer
