#include "unicode/utypes.h"
#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/lib/secure_filename.h>

#include <maps/libs/common/include/exception.h>

#include <unicode/regex.h>

namespace maps::wiki::importer {

namespace {
void checkIcuStatus(UErrorCode status, std::string_view operationDesc) {
    REQUIRE(U_SUCCESS(status),
        "Failed to " << operationDesc << ": ICU error #"
            << static_cast<int>(status) << ": " << u_errorName(status);
    );
}
} // namespace

std::string secureFilename(std::string_view filename)
{
    UErrorCode status = U_ZERO_ERROR;
    icu::RegexMatcher matcher("[^\\p{Letter}\\p{Digit}\\._-]", 0, status);
    checkIcuStatus(status, "initialize regex matcher");

    auto ustr = icu::UnicodeString::fromUTF8(filename);
    matcher.reset(ustr);
    ustr = matcher.replaceAll(icu::UnicodeString{}, status);
    checkIcuStatus(status, "perform regex replace");

    std::string result;
    return ustr.toUTF8String(result);
}

} // namespace maps::wiki::importer
