#include "task_params.h"

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/tasks/tasks.h>

namespace fs = std::filesystem;

namespace maps {
namespace wiki {
namespace importer {

namespace {

const std::string MDS_CONFIG_XPATH = "/config/common/mds";

mds::Configuration makeMdsConfig(const common::ExtendedXmlDoc& configXml)
{
    mds::Configuration mdsConfig(
        configXml.getAttr<std::string>(MDS_CONFIG_XPATH, "host"),
        configXml.getAttr<std::string>(MDS_CONFIG_XPATH, "namespace-name"),
        configXml.getAttr<std::string>(MDS_CONFIG_XPATH, "auth-header"));
    mdsConfig
        .setMaxRequestAttempts(3)
        .setRetryInitialTimeout(std::chrono::seconds(1))
        .setRetryTimeoutBackoff(2);
    return mdsConfig;
}

} // namespace

TaskParams::TaskParams(
        uint64_t taskId,
        uint64_t uid,
        Action action,
        const common::ExtendedXmlDoc& configXml,
        const std::string& editorConfigPath,
        const fs::path& workDir,
        pgpool3::Pool& corePool,
        pgpool3::Pool& viewPool)
    : taskId(taskId)
    , uid(uid)
    , branchId(0) //only trunk
    , action(action)
    , editorConfig(editorConfigPath)
    , importConfig()
    , globalAttrs{
        {"source", "import"},
        {"task_id", std::to_string(taskId)}}
    , workDir(workDir)
    , mdsConfig(makeMdsConfig(configXml))
    , corePool(corePool)
    , viewPool(viewPool)
    , mainTxn(corePool.masterWriteableTransaction())
{
}

} // namespace importer
} // namespace wiki
} // namespace maps
