#pragma once

#include "common.h"
#include "editor_config.h"
#include "import_config.h"

#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/mds/mds.h>

#include <boost/noncopyable.hpp>

#include <filesystem>

namespace maps {
namespace wiki {
namespace importer {

struct TaskParams : private boost::noncopyable
{
    TaskParams(
        uint64_t taskId,
        uint64_t uid,
        Action action,
        const common::ExtendedXmlDoc& configXml,
        const std::string& editorConfigPath,
        const std::filesystem::path& workDir,
        pgpool3::Pool& corePool,
        pgpool3::Pool& viewPool);

    const uint64_t taskId;
    const uint64_t uid;
    const revision::DBID branchId;
    const Action action;
    const EditorConfig editorConfig;
    const ImportConfig importConfig;
    const StringMap globalAttrs;
    const std::filesystem::path workDir;
    const mds::Configuration mdsConfig;

    pgpool3::Pool& corePool;
    pgpool3::Pool& viewPool;

    pgpool3::TransactionHandle mainTxn;
};

} // namespace importer
} // namespace wiki
} // namespace maps
