#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/tests/helpers.h>

namespace maps {
namespace wiki {
namespace importer {
namespace test {

Y_UNIT_TEST_SUITE_F(add_ad_objects, RandomDbFixture) {

Y_UNIT_TEST(test_add_polygon_ad)
{
    performAction(Action::Add, dataPath("shape_ad_multipolygon"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:ad", "1"},
                {"ad:population", "48000"},
                {"ad:disp_class", "5"},
                {"ad:level_kind", "1"}
            },
            {TestRelation{
                {{"rel:role", "center"}, {"rel:master", "ad"}, {"rel:slave", "ad_cnt"}},
                TestObject{
                    {{"cat:ad_cnt", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "part"}, {"rel:master", "ad"}, {"rel:slave", "ad_fc"}},
                TestObject{
                    {{"cat:ad_fc", "1"}},
                    {TestRelation{
                        {{"rel:role", "part"}, {"rel:master", "ad_fc"}, {"rel:slave", "ad_el"}},
                        TestObject{
                            {{"cat:ad_el", "1"}},
                            {TestRelation{
                                {{"rel:role", "start"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:role", "end"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            }}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "part"}, {"rel:master", "ad"}, {"rel:slave", "ad_fc"}},
                TestObject{
                    {{"cat:ad_fc", "1"}},
                    {TestRelation{
                        {{"rel:role", "part"}, {"rel:master", "ad_fc"}, {"rel:slave", "ad_el"}},
                        TestObject{
                            {{"cat:ad_el", "1"}},
                            {TestRelation{
                                {{"rel:role", "start"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:role", "end"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            }}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "part"}, {"rel:master", "ad"}, {"rel:slave", "ad_fc"}},
                TestObject{
                    {{"cat:ad_fc", "1"}, {"ad_fc:is_interior", "1"}},
                    {TestRelation{
                        {{"rel:role", "part"}, {"rel:master", "ad_fc"}, {"rel:slave", "ad_el"}},
                        TestObject{
                            {{"cat:ad_el", "1"}},
                            {TestRelation{
                                {{"rel:role", "start"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:role", "end"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            }}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "ad"}, {"rel:slave", "ad_nm"}},
                TestObject{
                    {{"cat:ad_nm", "1"}, {"ad_nm:lang", "ru"}, {"ad_nm:name", "Москва"}, {"ad_nm:is_local", "1"}},
                    {}
                }
            }}
        }}, 26);
}

Y_UNIT_TEST(test_add_point_ad)
{
    performAction(Action::Add, dataPath("geojson_ad"), 2);

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:ad", "1"},
                {"ad:population", "100000"},
                {"ad:disp_class", "5"},
                {"ad:level_kind", "4"}
            },
            {TestRelation{
                {{"rel:role", "center"}, {"rel:master", "ad"}, {"rel:slave", "ad_cnt"}},
                TestObject{
                    {{"cat:ad_cnt", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "ad"}, {"rel:slave", "ad_nm"}},
                TestObject{
                    {{"cat:ad_nm", "1"}, {"ad_nm:lang", "ru"}, {"ad_nm:name", "Васюки"}, {"ad_nm:is_local", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "render_label"}, {"rel:master", "ad"}, {"rel:slave", "ad_nm"}},
                TestObject{
                    {{"cat:ad_nm", "1"}, {"ad_nm:lang", "ru"}, {"ad_nm:name", "Нью Васюки"}, {"ad_nm:is_local", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {
                {"cat:ad", "1"},
                {"ad:population", "120000"},
                {"ad:disp_class", "5"},
                {"ad:level_kind", "4"}
            },
            {TestRelation{
                {{"rel:role", "center"}, {"rel:master", "ad"}, {"rel:slave", "ad_cnt"}},
                TestObject{
                    {{"cat:ad_cnt", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "ad"}, {"rel:slave", "ad_nm"}},
                TestObject{
                    {{"cat:ad_nm", "1"}, {"ad_nm:lang", "ru"}, {"ad_nm:name", "Алтуфьево"}},
                    {}
                }
            }}
        }});

    performAction(Action::Delete, dataPath("csv_delete_ad"));

    RevisionTest test2(pool());
    test2.testObjects({});
}

Y_UNIT_TEST(test_add_ad_el)
{
    performAction(Action::Add, dataPath("shape_ad_el"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:ad_el", "1"}},
            {TestRelation{
                {{"rel:role", "start"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                TestObject{
                    {{"cat:ad_jc", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "end"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                TestObject{
                    {{"cat:ad_jc", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {{"cat:ad_el", "1"}},
            {TestRelation{
                {{"rel:role", "start"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                TestObject{
                    {{"cat:ad_jc", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "end"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                TestObject{
                    {{"cat:ad_jc", "1"}},
                    {}
                }
            }}
        }});
}

} // Y_UNIT_TEST_SUITE

} // test
} // importer
} // wiki
} // maps
