#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/tests/helpers.h>

namespace maps {
namespace wiki {
namespace importer {
namespace test {

Y_UNIT_TEST_SUITE_F(add_indoor_objects, RandomDbFixture) {

Y_UNIT_TEST(test_add_indoor_scheme_simultaneously)
{
    performAction(Action::Add, dataPath("shape_indoor_scheme"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:indoor_plan", "1"}},
            {
                TestRelation{
                    {{"rel:master", "indoor_plan"}, {"rel:role", "official"}, {"rel:slave", "indoor_nm"}},
                    TestObject{
                        {{"cat:indoor_nm", "1"}, {"indoor_nm:lang", "ru"}, {"indoor_nm:name", "Золотой Вавилон"}},
                        {}
                    }
                },
                TestRelation{
                    {{"rel:master", "indoor_plan"}, {"rel:role", "assigned"}, {"rel:slave", "indoor_level"}},
                    TestObject{
                        {{"cat:indoor_level", "1"}, {"indoor_level:default", "1"}, {"indoor_level:order", "1"}, {"indoor_level:universal", "1"}},
                        {
                            TestRelation{
                                {{"rel:master", "indoor_level"}, {"rel:role", "official"}, {"rel:slave", "indoor_nm"}},
                                TestObject{
                                    {{"cat:indoor_nm", "1"}, {"indoor_nm:lang", "ru"}, {"indoor_nm:name", "1 этаж"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:master", "indoor_level"}, {"rel:role", "assigned_indoor_area"}, {"rel:slave", "indoor_area"}},
                                TestObject{
                                    {{"cat:indoor_area", "1"}, {"indoor_area:ft_type_id", "2402"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:master", "indoor_level"}, {"rel:role", "assigned_indoor_barrier"}, {"rel:slave", "indoor_barrier"}},
                                TestObject{
                                    {{"cat:indoor_barrier", "1"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:master", "indoor_level"}, {"rel:role", "assigned_indoor_poi_info"}, {"rel:slave", "indoor_poi_info"}},
                                TestObject{
                                    {{"cat:indoor_poi_info", "1"}, {"indoor_poi_info:ft_type_id", "2603"}},
                                    {
                                        TestRelation{
                                            {{"rel:master", "indoor_poi_info"}, {"rel:role", "official"}, {"rel:slave", "indoor_poi_nm"}},
                                            TestObject{
                                                {{"cat:indoor_poi_nm", "1"}, {"indoor_poi_nm:lang", "ru"}, {"indoor_poi_nm:name", "Инфо"}},
                                                {}
                                            }
                                        }
                                    }
                                }
                            },
                            TestRelation{
                                {{"rel:master", "indoor_level"}, {"rel:role", "assigned_indoor_poi_food"}, {"rel:slave", "indoor_poi_food"}},
                                TestObject{
                                    {{"cat:indoor_poi_food", "1"}, {"indoor_poi_food:ft_type_id", "180"}, {"poi:business_id", "169127565257"}, {"poi:business_rubric_id", "1387788996"}},
                                    {
                                        TestRelation{
                                            {{"rel:master", "indoor_poi_food"}, {"rel:role", "official"}, {"rel:slave", "indoor_poi_nm"}},
                                            TestObject{
                                                {{"cat:indoor_poi_nm", "1"}, {"indoor_poi_nm:lang", "ru"}, {"indoor_poi_nm:name", "СушиStore"}},
                                                {}
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    });
}


} // Y_UNIT_TEST_SUITE

} // test
} // importer
} // wiki
} // maps
