#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/tests/helpers.h>

namespace maps {
namespace wiki {
namespace importer {
namespace test {

Y_UNIT_TEST_SUITE_F(add_objects, RandomDbFixture) {

Y_UNIT_TEST(test_add_poi)
{
    performAction(Action::Add, dataPath("geojson_poi"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:poi_shopping", "1"},
                {"poi_shopping:url", "тест.рф"},
                {"poi_shopping:ft_type_id", "1307"},
                {"sys:import_source", "nmaps"},
                {"sys:import_source_id", "2345"},
                {"poi:business_id", "6789"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога и копыта"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "render_label"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Р и К"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "synonym"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога-копыта"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "en"}, {"poi_nm:name", "Horns and Hoofs"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "sr-Latn"}, {"poi_nm:name", "Serbian name"}},
                    {}
                }
            }}
        },
        TestObject{
            {
                {"cat:poi_leisure", "1"},
                {"poi_leisure:url", "qqq.ru"},
                {"poi_leisure:ft_type_id", "1801"}
            },
            {}
        }});
}

Y_UNIT_TEST(test_add_rd_addr)
{
    performAction(Action::Add, dataPath("dbf_rd"), 2);
    performAction(Action::Add, dataPath("mif_addr"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "Первомайская улица"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "associated_with"}, {"rel:master", "rd"}, {"rel:slave", "addr"}},
                TestObject{
                    {{"cat:addr", "1"}, {"addr:disp_class", "3"}},
                    {TestRelation{
                        {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                        TestObject{
                            {{"cat:addr_nm", "1"}, {"addr_nm:name", "3"}, {"addr_nm:lang", "fr"}},
                            {}
                        }
                    }}
                }
            }}
        },
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "улица Павлова"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "associated_with"}, {"rel:master", "rd"}, {"rel:slave", "addr"}},
                TestObject{
                    {{"cat:addr", "1"}, {"addr:disp_class", "3"}},
                    {TestRelation{
                        {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                        TestObject{
                            {{"cat:addr_nm", "1"}, {"addr_nm:name", "1"}, {"addr_nm:lang", "fr"}},
                            {}
                        }
                    }}
                }
            }}
        }});
}

Y_UNIT_TEST(test_delete_rd_addr)
{
    performAction(Action::Add, dataPath("dbf_rd"), 2);
    performAction(Action::Add, dataPath("mif_addr"));
    performAction(Action::Delete, dataPath("dbf_delete_addr"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "Первомайская улица"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "улица Павлова"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        }});
}

Y_UNIT_TEST(test_add_rd_addr_simultaneously)
{
    performAction(Action::Add, dataPath("shape_rd_addr"), 2);

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "Первомайская улица"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "associated_with"}, {"rel:master", "rd"}, {"rel:slave", "addr"}},
                TestObject{
                    {{"cat:addr", "1"}, {"addr:disp_class", "3"}},
                    {TestRelation{
                        {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                        TestObject{
                            {{"cat:addr_nm", "1"}, {"addr_nm:name", "1"}, {"addr_nm:lang", "fr"}},
                            {}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "associated_with"}, {"rel:master", "rd"}, {"rel:slave", "addr"}},
                TestObject{
                    {{"cat:addr", "1"}, {"addr:disp_class", "3"}},
                    {TestRelation{
                        {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                        TestObject{
                            {{"cat:addr_nm", "1"}, {"addr_nm:name", "5"}, {"addr_nm:lang", "fr"}},
                            {}
                        }
                    }}
                }
            }}
        },
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "улица Павлова"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "associated_with"}, {"rel:master", "rd"}, {"rel:slave", "addr"}},
                TestObject{
                    {{"cat:addr", "1"}, {"addr:disp_class", "3"}},
                    {TestRelation{
                        {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                        TestObject{
                            {{"cat:addr_nm", "1"}, {"addr_nm:name", "3"}, {"addr_nm:lang", "fr"}},
                            {}
                        }
                    }}
                }
            }}
        }});
}

Y_UNIT_TEST(test_add_hydro)
{
    performAction(Action::Add, dataPath("shape_hydro"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:hydro", "1"},
            },
            {TestRelation{
                {{"rel:role", "fc_part"}, {"rel:master", "hydro"}, {"rel:slave", "hydro_fc"}},
                TestObject{
                    {{"cat:hydro_fc", "1"}},
                    {TestRelation{
                        {{"rel:role", "part"}, {"rel:master", "hydro_fc"}, {"rel:slave", "hydro_fc_el"}},
                        TestObject{
                            {{"cat:hydro_fc_el", "1"}},
                            {TestRelation{
                                {{"rel:role", "start"}, {"rel:master", "hydro_fc_el"}, {"rel:slave", "hydro_fc_jc"}},
                                TestObject{
                                    {{"cat:hydro_fc_jc", "1"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:role", "end"}, {"rel:master", "hydro_fc_el"}, {"rel:slave", "hydro_fc_jc"}},
                                TestObject{
                                    {{"cat:hydro_fc_jc", "1"}},
                                    {}
                                }
                            }}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "fc_part"}, {"rel:master", "hydro"}, {"rel:slave", "hydro_fc"}},
                TestObject{
                    {{"cat:hydro_fc", "1"}, {"hydro_fc:is_interior", "1"}},
                    {TestRelation{
                        {{"rel:role", "part"}, {"rel:master", "hydro_fc"}, {"rel:slave", "hydro_fc_el"}},
                        TestObject{
                            {{"cat:hydro_fc_el", "1"}},
                            {TestRelation{
                                {{"rel:role", "start"}, {"rel:master", "hydro_fc_el"}, {"rel:slave", "hydro_fc_jc"}},
                                TestObject{
                                    {{"cat:hydro_fc_jc", "1"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:role", "end"}, {"rel:master", "hydro_fc_el"}, {"rel:slave", "hydro_fc_jc"}},
                                TestObject{
                                    {{"cat:hydro_fc_jc", "1"}},
                                    {}
                                }
                            }}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "hydro"}, {"rel:slave", "hydro_nm"}},
                TestObject{
                    {{"cat:hydro_nm", "1"}, {"hydro_nm:lang", "ru"}, {"hydro_nm:name", "Озеро Большое"}, {"hydro_nm:is_local", "1"}},
                    {}
                }
            }}
        }}, 17);
}

Y_UNIT_TEST(test_add_bld_bld_complex_simultaneously)
{
    performAction(Action::Add, dataPath("geojson_add_three_bld_bld_complex"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:bld_complex", "1"}},
            {TestRelation{
                {{"rel:role", "part"}, {"rel:master", "bld_complex"}, {"rel:slave", "bld"}},
                TestObject{
                    {{"cat:bld", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "part"}, {"rel:master", "bld_complex"}, {"rel:slave", "bld"}},
                TestObject{
                    {{"cat:bld", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {{"cat:bld_complex", "1"}},
            {TestRelation{
                {{"rel:role", "part"}, {"rel:master", "bld_complex"}, {"rel:slave", "bld"}},
                TestObject{
                    {{"cat:bld", "1"}},
                    {}
                }
            }}
        }
    });
}

} // Y_UNIT_TEST_SUITE

} // test
} // importer
} // wiki
} // maps
