#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/tests/helpers.h>

namespace maps {
namespace wiki {
namespace importer {
namespace test {

Y_UNIT_TEST_SUITE_F(delete_objects, RandomDbFixture) {

Y_UNIT_TEST(test_delete_rd_addr)
{
    performAction(Action::Add, dataPath("dbf_rd"), 2);
    performAction(Action::Add, dataPath("mif_addr"));
    performAction(Action::Delete, dataPath("dbf_delete_addr"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "Первомайская улица"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "улица Павлова"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        }});

    performAction(Action::Delete, dataPath("csv_delete_rd"));

    RevisionTest test2(pool());
    test2.testObjects({
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "Первомайская улица"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        }});
}

Y_UNIT_TEST(test_delete_rd_addra_2)
{
    performAction(Action::Add, dataPath("dbf_rd"), 2);
    performAction(Action::Add, dataPath("mif_addr"));
    performAction(Action::Delete, dataPath("csv_delete_rd"), 1, 1, CheckCommits::No);
    performAction(Action::Delete, dataPath("dbf_delete_addr"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "Первомайская улица"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "улица Павлова"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        }});
}

Y_UNIT_TEST(test_delete_merge_region)
{
    performAction(Action::Add, dataPath("geojson_merge_region"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:merge_region", "1"},
                {"merge_region:name", "Зона 7"},
                {"merge_region:status", "finished"}},
            {}
        }});

    performAction(Action::Delete, dataPath("csv_delete_merge_region"));

    RevisionTest test2(pool());
    test2.testObjects({});
}

} // Y_UNIT_TEST_SUITE

} // test
} // importer
} // wiki
} // maps
