#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/tests/helpers.h>

namespace maps {
namespace wiki {
namespace importer {
namespace test {

Y_UNIT_TEST_SUITE_F(edit_objects, RandomDbFixture) {

Y_UNIT_TEST(test_edit_point_ad_add_polygon)
{
    performAction(Action::Add, dataPath("geojson_ad"), 2);
    performAction(Action::Edit, dataPath("shape_edit_ad_add_polygon"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:ad", "1"},
                {"ad:population", "100000"},
                {"ad:disp_class", "5"},
                {"ad:level_kind", "4"}
            },
            {TestRelation{
                {{"rel:role", "center"}, {"rel:master", "ad"}, {"rel:slave", "ad_cnt"}},
                TestObject{
                    {{"cat:ad_cnt", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "part"}, {"rel:master", "ad"}, {"rel:slave", "ad_fc"}},
                TestObject{
                    {{"cat:ad_fc", "1"}},
                    {TestRelation{
                        {{"rel:role", "part"}, {"rel:master", "ad_fc"}, {"rel:slave", "ad_el"}},
                        TestObject{
                            {{"cat:ad_el", "1"}},
                            {TestRelation{
                                {{"rel:role", "start"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            },
                            TestRelation{
                                {{"rel:role", "end"}, {"rel:master", "ad_el"}, {"rel:slave", "ad_jc"}},
                                TestObject{
                                    {{"cat:ad_jc", "1"}},
                                    {}
                                }
                            }}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "ad"}, {"rel:slave", "ad_nm"}},
                TestObject{
                    {{"cat:ad_nm", "1"}, {"ad_nm:lang", "ru"}, {"ad_nm:name", "Васюки"}, {"ad_nm:is_local", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "render_label"}, {"rel:master", "ad"}, {"rel:slave", "ad_nm"}},
                TestObject{
                    {{"cat:ad_nm", "1"}, {"ad_nm:lang", "ru"}, {"ad_nm:name", "Нью Васюки"}, {"ad_nm:is_local", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {
                {"cat:ad", "1"},
                {"ad:population", "120000"},
                {"ad:disp_class", "5"},
                {"ad:level_kind", "4"}
            },
            {TestRelation{
                {{"rel:role", "center"}, {"rel:master", "ad"}, {"rel:slave", "ad_cnt"}},
                TestObject{
                    {{"cat:ad_cnt", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "ad"}, {"rel:slave", "ad_nm"}},
                TestObject{
                    {{"cat:ad_nm", "1"}, {"ad_nm:lang", "ru"}, {"ad_nm:name", "Алтуфьево"}},
                    {}
                }
            }}
        }}, 19);
}

Y_UNIT_TEST(test_edit_poi)
{
    performAction(Action::Add, dataPath("geojson_poi"));
    performAction(Action::Edit, dataPath("geojson_edit_poi"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:poi_shopping", "1"},
                {"poi_shopping:url", "тест2.рф"},
                {"poi_shopping:ft_type_id", "1307"},
                {"sys:import_source", "nmaps"},
                {"sys:import_source_id", "2345"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога и копыта 2"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "render_label"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Р и К"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "synonym"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога-копыта"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "synonym"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рожки да ножки"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "en"}, {"poi_nm:name", "Horns and Hoofs"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "fr"}, {"poi_nm:name", "Les cornes et les Sabots"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "sr-Latn"}, {"poi_nm:name", "Serbian name"}},
                    {}
                }
            }}
        },
        TestObject{
            {
                {"cat:poi_leisure", "1"},
                {"poi_leisure:url", "qqq2.ru"},
                {"poi_leisure:ft_type_id", "1801"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_leisure"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Дичь"}},
                    {}
                }
            }}
        }});
}

Y_UNIT_TEST(test_edit_poi_csv)
{
    performAction(Action::Add, dataPath("geojson_poi"));
    performAction(Action::Edit, dataPath("csv_edit_poi"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:poi_shopping", "1"},
                {"poi_shopping:url", "тест2.рф"},
                {"poi_shopping:ft_type_id", "1307"},
                {"sys:import_source", "nmaps"},
                {"sys:import_source_id", "2345"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога и копыта 2"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "render_label"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Р и К"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "synonym"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога-копыта"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "synonym"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рожки да ножки"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "en"}, {"poi_nm:name", "Horns and Hoofs"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "fr"}, {"poi_nm:name", "Les cornes et les Sabots"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "sr-Latn"}, {"poi_nm:name", "Serbian name"}},
                    {}
                }
            }}
        },
        TestObject{
            {
                {"cat:poi_leisure", "1"},
                {"poi_leisure:url", "qqq2.ru"},
                {"poi_leisure:ft_type_id", "1801"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_leisure"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Дичь"}},
                    {}
                }
            }}
        }});
}

Y_UNIT_TEST(test_edit_poi_category_csv)
{
    performAction(Action::Add, dataPath("geojson_poi"));
    performAction(Action::Edit, dataPath("csv_edit_poi_category"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:poi_leisure", "1"},
                {"poi_leisure:url", "тест.рф"},
                {"poi_leisure:ft_type_id", "1803"},
                {"sys:import_source", "nmaps"},
                {"sys:import_source_id", "2345"},
                {"poi:business_id", "6789"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_leisure"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога и копыта"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "render_label"}, {"rel:master", "poi_leisure"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Р и К"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "synonym"}, {"rel:master", "poi_leisure"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога-копыта"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_leisure"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "en"}, {"poi_nm:name", "Horns and Hoofs"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_leisure"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "sr-Latn"}, {"poi_nm:name", "Serbian name"}},
                    {}
                }
            }}
        },
        TestObject{
            {
                {"cat:poi_urban", "1"},
                {"poi_urban:url", "qqq.ru"},
                {"poi_urban:ft_type_id", "1901"}
            },
            {}
        }});
}

Y_UNIT_TEST(test_edit_poi_delete_name_csv)
{
    performAction(Action::Add, dataPath("geojson_poi"));
    performAction(Action::Edit, dataPath("csv_edit_poi_delete_name"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:poi_shopping", "1"},
                {"poi_shopping:url", "тест.рф"},
                {"poi_shopping:ft_type_id", "1307"},
                {"sys:import_source", "nmaps"},
                {"sys:import_source_id", "2345"},
                {"poi:business_id", "6789"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "ru"}, {"poi_nm:name", "Рога и копыта"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "official"}, {"rel:master", "poi_shopping"}, {"rel:slave", "poi_nm"}},
                TestObject{
                    {{"cat:poi_nm", "1"}, {"poi_nm:lang", "sr-Latn"}, {"poi_nm:name", "Serbian name"}},
                    {}
                }
            }}
        },
        TestObject{
            {
                {"cat:poi_leisure", "1"},
                {"poi_leisure:url", "qqq.ru"},
                {"poi_leisure:ft_type_id", "1801"}
            },
            {}
        }});
}

Y_UNIT_TEST(test_edit_poi_bad_category_csv)
{
    performAction(Action::Add, dataPath("geojson_poi"));
    performAction(Action::Edit, dataPath("csv_edit_poi_bad_category"), 2, 1, CheckCommits::No);
}

Y_UNIT_TEST(test_edit_poi_draft)
{
    performAction(Action::Add, dataPath("geojson_poi"), 0, 0, CheckCommits::Yes, ApproveCommits::No);
    performAction(Action::Edit, dataPath("geojson_edit_poi"), 4, 2, CheckCommits::No);
}

Y_UNIT_TEST(test_edit_rd_addr)
{
    performAction(Action::Add, dataPath("dbf_rd"), 2);
    performAction(Action::Add, dataPath("mif_addr"));
    performAction(Action::Edit, dataPath("dbf_edit_addr"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "Первомайская улица"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "associated_with"}, {"rel:master", "rd"}, {"rel:slave", "addr"}},
                TestObject{
                    {{"cat:addr", "1"}, {"addr:disp_class", "3"}},
                    {TestRelation{
                        {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                        TestObject{
                            {{"cat:addr_nm", "1"}, {"addr_nm:name", "1"}, {"addr_nm:lang", "fr"}},
                            {}
                        }
                    }}
                }
            },
            TestRelation{
                {{"rel:role", "associated_with"}, {"rel:master", "rd"}, {"rel:slave", "addr"}},
                TestObject{
                    {{"cat:addr", "1"}, {"addr:disp_class", "3"}},
                    {TestRelation{
                        {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                        TestObject{
                            {{"cat:addr_nm", "1"}, {"addr_nm:name", "3"}, {"addr_nm:lang", "fr"}},
                            {}
                        }
                    }}
                }
            }}
        },
        TestObject{
            {{"cat:rd", "1"}, {"rd:rd_type", "1"}},
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "rd"}, {"rel:slave", "rd_nm"}},
                TestObject{
                    {{"cat:rd_nm", "1"}, {"rd_nm:name", "улица Павлова"}, {"rd_nm:lang", "ru"}, {"rd_nm:is_local", "1"}},
                    {}
                }
            }}
        }});
}

Y_UNIT_TEST(test_add_bld_complex_to_existing_bld)
{
    performAction(Action::Add, dataPath("geojson_add_three_bld"));
    performAction(Action::Edit, dataPath("csv_bld_complex_bld"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {{"cat:bld_complex", "1"}},
            {TestRelation{
                {{"rel:role", "part"}, {"rel:master", "bld_complex"}, {"rel:slave", "bld"}},
                TestObject{
                    {{"cat:bld", "1"}},
                    {}
                }
            },
            TestRelation{
                {{"rel:role", "part"}, {"rel:master", "bld_complex"}, {"rel:slave", "bld"}},
                TestObject{
                    {{"cat:bld", "1"}},
                    {}
                }
            }}
        },
        TestObject{
            {{"cat:bld_complex", "1"}},
            {TestRelation{
                {{"rel:role", "part"}, {"rel:master", "bld_complex"}, {"rel:slave", "bld"}},
                TestObject{
                    {{"cat:bld", "1"}},
                    {}
                }
            }}
        }
    });
}

Y_UNIT_TEST(test_add_bld_complex_to_existing_bld_draft)
{
    performAction(Action::Add, dataPath("geojson_add_three_bld"), 0, 0, CheckCommits::Yes, ApproveCommits::No);

    auto expectedWarningCount = 8; // 3 skipped buildings + 2 skipped bld complexes + 3 messages about draft buildings
    auto expectedSkippedObjectCount = 3; // all 3 buildings

    performAction(
        Action::Edit,
        dataPath("csv_bld_complex_bld"),
        expectedWarningCount,
        expectedSkippedObjectCount,
        CheckCommits::No);
}

Y_UNIT_TEST(test_add_wrong_master_to_addr)
{
    performAction(Action::Add, dataPath("dbf_rd"), 2);
    performAction(Action::Add, dataPath("mif_addr"));

    // 2 skipped addrs + 2 skipped unexistent objects
    performAction(Action::Edit, dataPath("csv_edit_addr_wrong_master"), 4, 4, CheckCommits::No);
}

Y_UNIT_TEST(test_edit_addr_geometry)
{
    performAction(Action::Add, dataPath("dbf_rd"), 2);
    performAction(Action::Add, dataPath("mif_addr"));
    performAction(Action::Edit, dataPath("geojson_edit_addr_geometry"));

    RevisionTest test(pool());
    test.testObjects({
        TestObject{
            {
                {"cat:addr", "1"},
                {"addr:disp_class", "3"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                TestObject{
                    {
                        {"cat:addr_nm", "1"},
                        {"addr_nm:lang", "fr"},
                        {"addr_nm:name", "1"}
                    },
                    {}
                }
            }},
            // POINT (37.0 55.0) : SRID=4326 --> SRID=3395
            std::string("POINT (4118821.1593511220999062 7326837.7150455452501774)")
        },
        TestObject{
            {
                {"cat:addr", "1"},
                {"addr:disp_class", "3"}
            },
            {TestRelation{
                {{"rel:role", "official"}, {"rel:master", "addr"}, {"rel:slave", "addr_nm"}},
                TestObject{
                    {
                        {"cat:addr_nm", "1"},
                        {"addr_nm:lang", "fr"},
                        {"addr_nm:name", "3"}
                    },
                    {}
                }
            }},
            // POINT (38.0 56.0) : SRID=4326 --> SRID=3395
            std::string("POINT (4230140.6501443963497877 7522963.2412651209160686)")
        }}, 14);
}

} // Y_UNIT_TEST_SUITE

} // test
} // importer
} // wiki
} // maps
