#pragma once

#include <yandex/maps/wiki/tasks/common.h>

#include <cstdint>
#include <vector>
#include <string>

namespace maps::wiki::release {

using TaskId = uint64_t;

using UserId = uint64_t;

constexpr tasks::ObjectId NO_AOI = 0;
constexpr tasks::ObjectId NO_REGION = 0;

struct ValidationParam
{
    tasks::ObjectId aoiId;
    tasks::ObjectId regionId;
    tasks::PresetId presetId;

    bool operator==(const ValidationParam& toCompare) const
    {
        return std::tie(aoiId, regionId, presetId) ==
               std::tie(toCompare.aoiId, toCompare.regionId, toCompare.presetId);
    }
};

using ValidationParams = std::vector<ValidationParam>;

const std::string TASK_NAME = "prepare_stable_branch";

} // namespace maps::wiki::release
