#include "config.h"

#include <yandex/maps/wiki/common/default_config.h>

namespace maps::wiki::release {
namespace {

const std::string URL_XPATH = "/config/services/tasks/url";
const std::string VALIDATIONS_XPATH = "/config/services/tasks/" + TASK_NAME
                                      + "/validations";
const std::string VALIDATION_NODE = "validation";
const std::string AOI_ATTR = "aoi";
const std::string REGION_ATTR = "region";
const std::string PRESET_ID_ATTR = "preset-id";

} // anonymous namespace

Config::Config(const std::string& cfgPath)
{
    if (cfgPath.empty()) {
        cfg_ = common::loadDefaultConfig();
    } else {
        cfg_.reset(new common::ExtendedXmlDoc(cfgPath));
    }

    tasksUrl_ = cfg_->get<std::string>(URL_XPATH);

    auto validationsNode = cfg_->node(VALIDATIONS_XPATH, true);
    if (!validationsNode.isNull()) {
        auto validationNodes = validationsNode.nodes(VALIDATION_NODE, true);
        for (size_t i = 0; i < validationNodes.size(); ++i) {
            auto validation = validationNodes[i];
            auto aoiId = validation.attr<tasks::ObjectId>(AOI_ATTR, NO_AOI);
            auto regionId = validation.attr<tasks::ObjectId>(REGION_ATTR, NO_REGION);
            auto presetId = validation.attr<tasks::PresetId>(PRESET_ID_ATTR);
            validationParams_.push_back({aoiId, regionId, presetId});
        }
    }
}

} // namespace maps::wiki::release
