#pragma once

#include "common.h"

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <memory>
#include <string>

namespace maps::wiki::release {

class Config {
public:
    explicit Config(const std::string& cfgPath = std::string{});

    common::ExtendedXmlDoc& configDoc() { return *cfg_; }
    const std::string& tasksUrl() const { return tasksUrl_; }
    const ValidationParams& validationParams() const { return validationParams_; }

private:
    std::unique_ptr<common::ExtendedXmlDoc> cfg_;
    std::string tasksUrl_;
    ValidationParams validationParams_;
};

} // namespace maps::wiki::release
