#pragma once

#include <yandex/maps/wiki/tasks/task_logger.h>

#include <sstream>

namespace maps::wiki::release {

/// to duplicate messages in log and Postgres
class LoggerProxy {
public:
    explicit LoggerProxy(tasks::TaskPgLogger& logger,
                         tasks::Severity severity = tasks::Severity::Info)
        : severity_{severity}, pgMsg_{logger, severity}
    {
    }

    ~LoggerProxy();

    template <class T>
    LoggerProxy& operator<<(const T& val)
    {
        pgMsg_ << val;
        msg_ << val;
        return *this;
    }

private:
    tasks::Severity severity_;
    tasks::Message pgMsg_;
    std::ostringstream msg_;
};

} // namespace maps::wiki::release

#define DUAL_INFO(logger) maps::wiki::release::LoggerProxy(logger)

#define DUAL_WARN(logger)                                                    \
    maps::wiki::release::LoggerProxy(logger,                                 \
                                     maps::wiki::tasks::Severity::Warn)

#define DUAL_ERROR(logger)                                                   \
    maps::wiki::release::LoggerProxy(logger,                                 \
                                     maps::wiki::tasks::Severity::Error)
