#include "../config.h"

#include <library/cpp/testing/common/env.h>

#include <boost/test/unit_test.hpp>
#include <boost/format.hpp>

#include <fstream>

namespace maps::wiki::release::test {

const boost::format TEMPLATE(R"(<?xml version='1.0' encoding='utf-8'?>
<config>
    <extends>%1%</extends>
    <services>
        <tasks>
            <url>http://tasks.nkbeta.dev.cloud.maps.yandex.net/</url>
            <prepare_stable_branch>
                <validations>
                    <validation preset-id="20"/>
                    <validation aoi="4751" preset-id="21"/>
                    <validation aoi="4761" preset-id="22"/>
                    <validation aoi="4771" preset-id="23"/>
                    <validation region="4781" preset-id="24"/>
                    <validation region="4791" preset-id="25"/>
                </validations>
            </prepare_stable_branch>
        </tasks>
    </services>
</config>)");

const auto SERVICES_BASE_PATH = ArcadiaSourceRoot() +
    "/maps/wikimap/mapspro/cfg/services/services-base.xml";

BOOST_AUTO_TEST_CASE(test_config)
{
    const ValidationParams EXPECTED = {
        {0, 0, 20},
        {4751, 0, 21},
        {4761, 0, 22},
        {4771, 0, 23},
        {0, 4781, 24},
        {0, 4791, 25}};

    auto config = boost::format(TEMPLATE) % SERVICES_BASE_PATH;

    const std::string filename = "config.xml";

    std::ofstream file(filename, std::ios::out);
    file << config.str();
    file.close();

    Config cfg(filename);
    const auto& params = cfg.validationParams();
    BOOST_CHECK(params == EXPECTED);
}

} // namespace maps::wiki::release::test
