#pragma once

#include "common.h"

#include <yandex/maps/wiki/revision/branch.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <optional>

namespace maps::wiki::release {

revision::Branch getApprovedBranch(pgpool3::Pool& pool);

std::optional<revision::Branch>
getStableBranch(pgpool3::Pool& pool);

std::optional<revision::DBID>
mostRecentArchiveBranchId(pgpool3::Pool& pool);

bool isTaskFrozen(pgpool3::Pool& pool, TaskId taskId);

void saveResult(pgpool3::Pool& pool, TaskId taskId, revision::DBID branchId);

bool isTaskScheduled(pgpool3::Pool& pool);

std::optional<revision::Branch>
publishStableBranch(
    pgpool3::Pool& corePool,
    pgpool3::Pool& labelsPool,
    revision::UserID uid);

std::optional<revision::Branch>
deleteExceedingArchiveBranch(
    pgpool3::Pool& corePool,
    pgpool3::Pool& viewPool,
    pgpool3::Pool& labelsPool,
    revision::UserID uid);

} // namespace maps::wiki::release
