#pragma once

#include <maps/libs/http/include/http.h>
#include <maps/libs/json/include/value.h>

#include <set>
#include <string>
#include <vector>

namespace maps::wiki {

enum class Dismissed : bool
{
    Yes = true,
    No = false
};

struct StaffUser
{
    std::string login;
    std::vector<std::string> nmapsLogins;
    Dismissed dismissed;
};

using StaffUsers = std::vector<StaffUser>;

class Staff
{
public:
    Staff(
        const std::string& urlBase,
        const std::string& oAuthToken);

    StaffUsers getUsersByDepartment(
        const std::string& departmentUrl) const;
    StaffUsers getUsersByLogins(
        const std::set<std::string>& logins) const;
private:
    http::URL makeUsersByDepartmentUrl(
        const std::string& departmentUrl,
        int page = 1) const;

    http::URL makeUsersByLoginsUrl(const std::set<std::string>& logins) const;

    void parseJsonResponseUsers(
        const json::Value& responseJson,
        StaffUsers& users) const;

    mutable http::Client client_;
    std::string urlBase_;
    http::HeaderMap headers_;
};

} // maps::wiki
