COMMON_MAKEFILE_DIR := $(dir $(abspath $(lastword $(MAKEFILE_LIST))))
CFG_DIR := $(COMMON_MAKEFILE_DIR)/../../../cfg

YANDEX_CONFIG = $(CFG_DIR)/services/services.local.$(USER).xml

daemon  := /sbin/start-stop-daemon
red     = $$(tput setf 1)
green   = $$(tput setf 2)
magenta = $$(tput setf 5)
normal  = $$(tput sgr0)

#M2C: NO
ifdef VERBOSE
QUIET =
else
QUIET = @
endif

# Generates shell command that prints pretty header
#
# Required paramters
# ==================
#   $(1) - header to show
show-header = printf "$(green)%s\n%s\n$(normal)" $(1) $$(echo $(1) | sed -e 's/./=/g')

# Generates shell command that prints one element of definition list.
#
# Required parameters
# ===================
#   $(1) - item name text
#   $(2) - item description text
show-item = printf "  $(magenta)%-25s$(normal) %s\n" $(1) $(2)

# Generates shell command that prints a message
#
# Required parameters
# ===================
#   $(1) - text to print
print-message = printf "$(green)%s$(normal)\n" $(1)

# Generates shell command that starts daemon
#
# Required parameters
# ===================
#   $(1) - shell command to run as string
#   $(2) - pidfile
#   $(3) - environment
define start-daemon
  $(daemon) \
	--start \
	--make-pidfile --pidfile=$(2) \
	--oknodo \
	--background \
	--startas /bin/bash \
	-- -c $(3)" exec "$(1)
endef

# Generates shell command that stops a daemon
#
# Required paremeters
# ===================
#   $(1) - daemon pidfile
stop-daemon = $(daemon) --stop --oknodo --pidfile=$(1) --retry 1

# Evaluation of this template mixins common development targets to run
# pubsub workers.
#
# Required parameters
# ===================
#   $(1) - name of the worker binary
#
# Declares variables
# ==================
#   $(1)_PIDFILE - path to worker pidfile
#   $(1)_LOGFILE - path to worker logfile
#
# It's expected that the following variables are defined:
#  BUILD_DEPENDS - variable containing list of packages required to
#                  build the worker binary
define pubsub-worker-dev-targets-template
$(1)_PIDFILE := $$(CURDIR)/$(1).pid
$(1)_LOGFILE := $$(CURDIR)/$(1).log

.PHONY: start stop help

start:: stop
	ya make
	@$$(call print-message,"Starting $(1)...")
	$(QUIET)$(call start-daemon,"$(abspath $(1)) --config $(YANDEX_CONFIG) >$$($(1)_LOGFILE) 2>&1",$$($(1)_PIDFILE),$(WORKER_ENV))
	@$$(call print-message,"Started $(1)")

stop::
	@$$(call print-message,"Stopping $(1)...")
	$(QUIET)$(call stop-daemon,$$($(1)_PIDFILE))
	@$$(call print-message,"Stopped $(1)")

help:
	@echo
	@$$(call show-header,"Supported Targets")
	@$$(call show-item,help,"Shows this help message")
	@$$(call show-item,start,"Starts $(1) daemon")
	@$$(call show-item,stop,"Stops $(1) daemon")
	@echo

clean:: stop
	rm -f $$($(1)_PIDFILE) $$($(1)_LOGFILE)
endef
