#pragma once

#include <maps/libs/xml/include/xml.h>

#include <string>
#include <unordered_map>

namespace maps {
namespace wiki {
namespace contours {

typedef signed short Zoom;

struct ZoomRange {
    Zoom zmin;
    Zoom zmax;
};

class GeneralizationLoader;

/**
 * \brief Generalization strategy based on area
 * \see https://wiki.yandex-team.ru/maps/dev/core/servants/wikimap/generalisation
 */
class Generalization {
public:
    ZoomRange zoomRange(double area) const;

private:
    struct Size {
        double width;
        double height;
    };

    const ZoomRange zoomRange_;
    const Size window_;
    const Size minSize_;
    const double minFraction_;

    Generalization(const ZoomRange& zoomRange, const xml3::Node& gabarits);

    friend class GeneralizationLoader;
};

class GeneralizationLoader {
public:
    static ZoomRange zoomRange(const std::string& category, double area);
private:
    std::unordered_map<std::string, Generalization> categoryToGeneralization_;
    GeneralizationLoader();
};

} // contours
} // wiki
} // maps
