#pragma once

#include "contour_object.h"
#include "revision_meta/categories.h"

#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <boost/noncopyable.hpp>

namespace maps {
namespace wiki {
namespace contours {

/**
 * \brief thread-safe contour objects loader
 */
class Loader : boost::noncopyable {
public:
    Loader
        ( common::PoolHolder& pool
        , revision_meta::TCommitId commitId
        , const Params& params
        );

    revision_meta::TObjectIdSet allObjectIds() const;

    revision_meta::TObjectIdSet
    affectedObjectIds(revision_meta::TCommitId minCommitId) const;

    ContourObjects load(const revision_meta::TObjectIdSet& ids) const;

private:
    common::PoolHolder& pool_;
    const revision_meta::TCommitId commitId_;
    const Params& params_;
    revision_meta::TStringSet contourObjectCategoryIds_;
    revision_meta::TStringSet dependFromMasterContourObjectCategoryIds_;
    revision_meta::Categories categories_;
};

} // contours
} // wiki
} // maps
