#include "../pubsub.h"
#include "../tools.h"

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <iostream>

using namespace maps;
using namespace maps::wiki;
using namespace maps::wiki::contours;

namespace {

constexpr size_t WARN_QUEUE_SIZE {33000};
constexpr size_t ERROR_QUEUE_SIZE {2*WARN_QUEUE_SIZE};

} // namespace

int main(int, const char**) try
{
    log8::setLevel(maps::log8::Level::FATAL);

    auto doc = wiki::common::loadDefaultConfig();
    auto revisionPool = makePoolHolder(*doc, DB_LONG_READ, POOL_EDITOR_TOOL);
    auto viewPool = makePoolHolder(*doc, DB_VIEW_TRUNK, POOL_EDITOR_TOOL);
    const auto queue = queueSize
        ( *revisionPool->pool().slaveTransaction()
        , *viewPool->pool().slaveTransaction()
        );

    if (queue > ERROR_QUEUE_SIZE) {
        std::cout << "2;Error: queue size is " << queue << " commits" << std::endl;
    } else if (queue > WARN_QUEUE_SIZE) {
        std::cout << "1;Warning: queue size is " << queue << " commits" << std::endl;
    } else {
        std::cout << "0;Ok: queue size is " << queue << " commits" << std::endl;
    }
    return EXIT_SUCCESS;
} catch (const std::exception& e) {
    std::cout << "2;Error: " << e.what() << std::endl;
    return EXIT_SUCCESS;
} catch (...) {
    std::cout << "2;Error: unknown exception" << std::endl;
    return EXIT_SUCCESS;
}
